;----------------------------------------------------------------------------
;
;    MODULE NAME:   MSIDIFF.MM
;
;        $Author:   USER "Dennis"  $
;      $Revision:   1.3  $
;          $Date:   15 Sep 2007 18:31:32  $
;       $Logfile:   C:/DBAREIS/Projects.PVCS/Win32/MakeMsi/MsiDiff.MM.pvcs  $
;      COPYRIGHT:   (C)opyright Dennis Bareis, Australia, 2003
;                   All rights reserved.
;
; DESCRIPTION
; ~~~~~~~~~~~
; This is the source script actually used to build the MSIDIFF MSI.
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;--- Load Common Definitions and MAKEMSI Support ----------------------------
;----------------------------------------------------------------------------
#define  COMPANY_SUMMARY_SCHEMA           110      ;;Minimum v1.1 Installer
#include "MAKEMSI.MM.H"


;----------------------------------------------------------------------------
;--- Make sure the version number for the MSI matches that of the VBS -------
;----------------------------------------------------------------------------
#define MSIDIFF_VBS   out\MsiDiff.VBS
#DefineRexx ''
    ;--- Read the files contents --------------------------------------------
    @@VbsFile = "<$MSIDIFF_VBS>"
    call FileClose @@VbsFile, 'N';
    @@Contents = charin(@@VbsFile,1, 999999);
    call FileClose @@VbsFile;

    ;--- Extract the Program version number ---------------------------------
    parse var @@Contents 'PgmVersion = "' @@VbsVersion '"'
    if  @@VbsVersion = '' then
        error('Could not determine the programs version (in "' || @@VbsFile || '").');

    ;--- Compare to that of the MSI -----------------------------------------
    parse value '<$ProductVersion>' with @@Maj '.' @@Zero '.' @@Min '.';
    @@MsiVersion = @@Maj || '.' || @@Min;
    if  @@MsiVersion <> @@VbsVersion then  ;;Don't care
    #(
        error('The version of the MSI does not match the VBS!',
              'VBS Version : ' || @@VbsVersion,
              'MSI Version : ' || @@MsiVersion || ' (<$ProductVersion>)');

    #)
#DefineRexx


;----------------------------------------------------------------------------
;--- Define Install dir -----------------------------------------------------
;----------------------------------------------------------------------------
<$DirectoryTree Key="INSTALLDIR"  Dir="C:\Program Files\MsiDiff.MM" Change="\">


;----------------------------------------------------------------------------
;--- Include the required files ---------------------------------------------
;----------------------------------------------------------------------------
<$CompPerFile "<$MSIDIFF_VBS>"                 Comment='Dumps or compares Windows Installer databases.'>
<$CompPerFile "out\_CompMsi.VBS"               Comment='Not intended for user use (used internally).'>
<$CompPerFile "c_summary\out\MsiSummRead.exe"  Comment='Used by MSIDIFF if available to work around MS summary read bugs.'>

;----------------------------------------------------------------------------
;--- Add required Icons (these need to be installed into filesystem) --------
;----------------------------------------------------------------------------
#option PUSH DefineMacroReplace=ON
#define RandomishIconBit  - <$ProductVersion> - <?=time('s')> ;;Prevents Windows accessing old icons (incorrectly)
#define MmDumpTxt.ICO  MmDumpTxt <$RandomishIconBit>.ICO
#define MmDiffTxt.ICO  MmDiffTxt <$RandomishIconBit>.ICO
#option POP
<$Component "Icon" Create="Y" Directory_="INSTALLDIR">
    <$File Destination="<$MmDumpTxt.ICO>"  Source="MmDumpTxt.ico"   Comment="Icon for generated MSIDIFF output." KeyPath="Y">
    <$File Destination="<$MmDiffTxt.ICO>"  Source="MmDiffTxt.ico"   Comment="Icon for generated MSIDIFF output.">
<$/Component>


;----------------------------------------------------------------------------
;--- Simplify editing and remaking generated output -------------------------
;----------------------------------------------------------------------------
<$FIND_DEFAULT_TEXT_EDITOR_CMDLINE>
#(
    #define ExtnBuildOpts
    <$Extn ".{$Extn}" ProgId="MAKEMSI.{$Extn}" KEYPATH="Y" Description="{$Desc}" Icon="[INSTALLDIR]<${$Icon}>" AlwaysShow="Y">
        <$ExtnAction Key="Open"           Description="Edit {$Desc}"            Command=^[DEFAULT_TEXT_EDITOR_CMDLINE]^>
        ;<$ExtnAction Key="ZZ_100_Build_D" Description="{$DoWhat} - Development" Command=^"[WSCRIPT.EXE]" "%MAKEMSI_DIR%_MM.VBS" "%1" D^>
        ;<$ExtnAction Key="ZZ_100_Build_P" Description="{$DoWhat} - Production"  Command=^"[WSCRIPT.EXE]" "%MAKEMSI_DIR%_MM.VBS" "%1" P^>
    <$/Extn>
#)
<$Component "EditMakeAssociations" Create="Y" Directory_="INSTALLDIR">
    <$ExtnBuildOpts Extn="<$MSIDUMP_OUTPUT_COMPLETE>"   Desc="MSIDIFF Dump Script"       DoWhat="Build new MSI" Icon='MmDumpTxt.ico'>
    <$ExtnBuildOpts Extn="<$MSIDUMP_OUTPUT_DIFFERENCE>" Desc="MSIDIFF Difference Script" DoWhat="Update MSI"    Icon='MmDiffTxt.ico'>
<$/Component>


;----------------------------------------------------------------------------
;--- Set up some "right click" actions --------------------------------------
;----------------------------------------------------------------------------
#{  SET ^TYPE={ }<$MSI_DATABASE_TYPES> Msi.Patch <$MSI_TRANSFORM_TYPES>^
   ;--- Create a component for each type ------------------------------------
   <$Component "RIGHT_CLICK_MSIDUMP_<??SET_TYPE>_ALL" Create="Y" Directory_="INSTALLDIR">
       ;--- Dump Whole Database ---------------------------------------------
       #(
           <$Registry
                  HKEY="CLASSES_ROOT"
                   KEY="<??SET_TYPE>\shell\Z_MAKEMSI_30_MSIDIFF"
                 VALUE="Dump -> MAKEMSI format"
               KEYPATH="Y"
           >
       #)
       #(
           <$Registry
                   HKEY="CLASSES_ROOT"
                    KEY="<??SET_TYPE>\shell\Z_MAKEMSI_30_MSIDIFF\command"
                  VALUE='"[WSCRIPT.EXE]" "[INSTALLDIR]_CompMsi.VBS" D "%1"'
           MsiFormatted="VALUE"
           >
       #)
   <$/Component>
#}
#{  SET ^TYPE={ }<$MSI_DATABASE_TYPES> Msi.Patch^
   <$Component "RIGHT_CLICK_MSIDUMP_<??SET_TYPE>_DIFF" Create="Y" Directory_="INSTALLDIR">
       #(
           <$Registry
                  HKEY="CLASSES_ROOT"
                   KEY="<??SET_TYPE>\shell\Z_MAKEMSI_35_MSIDIFF_TEM"
                 VALUE="Compare -> MAKEMSI format"
               KEYPATH="Y"
           >
       #)
       #(
           <$Registry
                   HKEY="CLASSES_ROOT"
                    KEY="<??SET_TYPE>\shell\Z_MAKEMSI_35_MSIDIFF_TEM\command"
                  VALUE='"[WSCRIPT.EXE]" "[INSTALLDIR]_CompMsi.VBS" C "%1"'
           MsiFormatted="VALUE"
           >
       #)
   <$/Component>
#}

;----------------------------------------------------------------------------
;--- Doco Shortcuts ---------------------------------------------------------
;----------------------------------------------------------------------------
#(
   #define CHM
   The document is in Windows Compiled Help format and so
   has a contents, an index and can be searched.
#)
<$Component "ShortCutDocoMSIDIFF" Create="Y" Directory_="INSTALLDIR">
   <$Icon KEY="@HELP" ".\help.ico">
   <$File Source="OUT\DOCO\MSIDIFF\MSIDIFF.chm" Comment='MSIDIFF documentation. <$CHM>' KeyPath="Y">
   #(
       <$Shortcut
                   Dir="ProgramMenuFolder"
               Feature="."                             ;;Advertise current
                 Title="MsiDiff Documentation"
           Description="Documents the MSIDIFF tool (version <$ProductVersion>)."
                  Icon="@HELP"
               WorkDir="INSTALLDIR"
       >
   #)
<$/Component>

;----------------------------------------------------------------------------
;--- Remember install location ----------------------------------------------
;----------------------------------------------------------------------------
<$Component "ENVIRONMENT_AND_REGISTRY" Create="Y" Directory_="INSTALLDIR" LM="Y">
   ;--- Point to the install directory --------------------------------------
   <$Environment NAME="MSIDIFF_DIR" VALUE="[INSTALLDIR]">
<$/Component>

